import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

import '../../../infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class OrderTransactionItem extends StatelessWidget {
  final String title;
  final num? price;
  final String? currency;
  final IconData iconData;

  const OrderTransactionItem({
    super.key,
    required this.title,
    required this.iconData,
    this.price,
    this.currency,
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          child: Row(
            children: [
              Icon(iconData, color: Style.black),
              4.horizontalSpace,
              Text(
                title,
                style: Style.interNormal(
                  color: Style.black,
                  size: 16,
                  letterSpacing: -0.4,
                ),
              ),
            ],
          ),
        ),
        Text(
          AppHelpers.numberFormat(
            number: price,
            isOrder: true,
            symbol: currency,
          ),
          style: Style.interRegular(
            color: Style.black,
            size: 16,
            letterSpacing: -0.4,
          ),
        ),
      ],
    );
  }
}
